/**
 * \file: mspin_connection_tcp_listener.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * mySPIN TCP/TLS Listener
 *
 * \component: MSPIN
 *
 * \author: Thilo Bjoern Fickel BSOT/PJ-ES1 thilo.fickel@bosch-softtec.com
 *
 * @copyright: (c) 2016 Bosch SoftTec GmbH
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_CONNECTION_TCP_TLS_LISTENER_H_
#define MSPIN_CONNECTION_TCP_TLS_LISTENER_H_

#include "mspin_typedef.h"
#include "mspin_connection_tls_server.h"

#include <netdb.h>          //in_addr_t

typedef struct
{
    int listenFD;
    int port;
    BOOL quitListener;
    pthread_t listenThreadID;

    MSPIN_OnAcceptIncomingConnection onAccept;
    MSPIN_OnConnectionClosed onClose;
    void* onListenForConnectionsContext;

    BOOL secured; //when TRUE connection is TLS secured, otherwise it's plain TCP/IP
    mspin_tls_parameter_t* pTLSParameter;
} mspin_tcp_ListenerContext_t;

MSPIN_ERROR mspin_tcp_startListener(S32 tcpPort, MSPIN_TLS_CONFIGURATION_t* pTLSConfig,
        MSPIN_OnAcceptIncomingConnection acceptCB, MSPIN_OnConnectionClosed closedCB, void* callbackContext);

MSPIN_ERROR mspin_tcp_stopListener(BOOL secured);

void mspin_tcp_signalConnectionClosed(int socketFD, in_addr_t ipAddr, MSPIN_TCP_CONNECTION_END_REASON reason);

#endif /* MSPIN_CONNECTION_TCP_TLS_LISTENER_H_ */
